package com.bxm.warcar.cache.refresh;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Refreshable;
import com.bxm.warcar.cache.Updater;

import java.util.Map;

/**
 * @author allen
 * @date 2017-12-04
 */
public abstract class AbstractRefreshable implements Refreshable {

    protected abstract String getCacheKey(Map<String, Object> parameters);

    @Override
    public void refresh(Map<String, Object> parameters) {
        Updater updater = getUpdater();
        updater.remove(getCacheKey(parameters));
    }
}
