package com.bxm.warcar.cache.serialization;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.cache.Serialization;

/**
 * @author allen
 * @date 2017-12-04
 */
public class JSONSerialization implements Serialization<String> {

    @Override
    public String serialize(Object data) {
        return JSON.toJSONString(data);
    }

    @Override
    public <T> T deserialize(String modalValue, Class<T> cls) {
        return JSON.parseObject(modalValue, cls);
    }
}
