package com.bxm.warcar.cache;

import java.util.Map;

/**
 * 更新器
 */
public interface Updater {

    void update(KeyGenerator keyGenerator, Object value);

    void update(KeyGenerator keyGenerator, Object value, int expireTimeInSecond);

    void updateWithSelector(KeyGenerator keyGenerator, Object value, int selector);

    void updateWithSelector(KeyGenerator keyGenerator, Object value, int expireTimeInSecond, int selector);

    void remove(KeyGenerator keyGenerator);

    void removeWithSelector(KeyGenerator keyGenerator, int selector);

    void hupdate(KeyGenerator keyGenerator, String field, Object value);

    void hupdate(KeyGenerator keyGenerator, String field, Object value, int expireTimeInSecond);

    void hupdateWithSelector(KeyGenerator keyGenerator, String field, Object value, int selector);

    void hupdateWithSelector(KeyGenerator keyGenerator, String field, Object value, int expireTimeInSecond, int selector);

    void hremove(KeyGenerator keyGenerator, String...field);

    void hremoveWithSelector(KeyGenerator keyGenerator, int selector, String...field);

    /**
     * 批量更新 hash 数据。注意数据是不会再经过序列化的，传入前请自行序列化。
     * @param keyGenerator
     * @param hash
     */
    void hmupdate(KeyGenerator keyGenerator, Map<String, String> hash);

    void hmupdateWithSelector(KeyGenerator keyGenerator, Map<String, String> hash, int selector);

    /**
     * 批量更新 hash 数据。注意数据是不会再经过序列化的，传入前请自行序列化。
     *
     * @param keyGenerator
     * @param hash
     * @param expireTimeInSecond
     */
    void hmupdate(KeyGenerator keyGenerator, Map<String, String> hash, int expireTimeInSecond);

    void hmupdateWithSelector(KeyGenerator keyGenerator, Map<String, String> hash, int expireTimeInSecond, int selector);

    /**
     * 返回这个获取器具体的实现原生客户端
     * @return
     */
    Object getClientOriginal();
}
