package com.bxm.warcar.xcache;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.KeyGenerator;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @see TargetFactory
 * @author allen
 * @date 2019/1/4
 * @since 1.0.0
 */
public class Target<T> implements Serializable {

    private static final long serialVersionUID = 6209064360065762906L;
    private KeyGenerator keyGenerator;
    private String field;
    private DataExtractor<T> dataExtractor;
    private DataExtractor<List<T>> listDataExtractor;
    private DataExtractor<Map<String, T>> mapDataExtractor;
    private Class<T> cls;
    private int expireTimeInSecond = 0;
    private int selector = -1;

    /**
     * 是否跳过本地缓存
     */
    private boolean skipNativeCache = false;

    /**
     * 批的数量，如用在 scan / zscan / hscan 等操作时
     */
    private int batchSize = 3000;

    Target() {}

    public KeyGenerator getKeyGenerator() {
        return keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public DataExtractor<T> getDataExtractor() {
        return dataExtractor;
    }

    public void setDataExtractor(DataExtractor<T> dataExtractor) {
        this.dataExtractor = dataExtractor;
    }

    public Class<T> getCls() {
        return cls;
    }

    public void setCls(Class<T> cls) {
        this.cls = cls;
    }

    public int getExpireTimeInSecond() {
        return expireTimeInSecond;
    }

    public void setExpireTimeInSecond(int expireTimeInSecond) {
        this.expireTimeInSecond = expireTimeInSecond;
    }

    public int getSelector() {
        return selector;
    }

    public void setSelector(int selector) {
        this.selector = selector;
    }

    public DataExtractor<List<T>> getListDataExtractor() {
        return listDataExtractor;
    }

    public void setListDataExtractor(DataExtractor<List<T>> listDataExtractor) {
        this.listDataExtractor = listDataExtractor;
    }

    public DataExtractor<Map<String, T>> getMapDataExtractor() {
        return mapDataExtractor;
    }

    public void setMapDataExtractor(DataExtractor<Map<String, T>> mapDataExtractor) {
        this.mapDataExtractor = mapDataExtractor;
    }

    public int getBatchSize() {
        return batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isSkipNativeCache() {
        return skipNativeCache;
    }

    public void setSkipNativeCache(boolean skipNativeCache) {
        this.skipNativeCache = skipNativeCache;
    }
}
