/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.Lock;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.concurrent.TimeUnit;

/**
 * <b>Redis 的实现存在死锁的问题，使用时请注意。</b>
 * @author allen
 * @since 1.0.0
 */
public class JedisLock implements Lock {

    private final int expireTimeInSeconds = 60;
    private final JedisPool jedisPool;

    public JedisLock(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public boolean tryAcquire(String keyName) {
        Jedis jedis = jedisPool.getResource();
        try {
            Long rst = jedis.setnx(keyName, keyName);
            boolean b = null != rst && rst == 1;
            if (b) {
                jedis.expire(keyName, expireTimeInSeconds);
            }
            return b;
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public boolean tryAcquire(String keyName, long time, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public void release(String keyName) {
        Jedis jedis = jedisPool.getResource();
        try {
            jedis.del(keyName);
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}
