package com.bxm.warcar.xcache;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.KeyGenerator;

import java.util.List;
import java.util.Map;

/**
 * Target building factory
 *
 * @author allen
 * @date 2019/1/4
 * @since 1.0.0
 */
public class TargetFactory<T> {

    private Target<T> target = new Target<>();

    public TargetFactory() {}

    public Target<T> build() {
        return target;
    }

    public TargetFactory<T> keyGenerator(KeyGenerator keyGenerator) {
        target.setKeyGenerator(keyGenerator);
        return this;
    }

    public TargetFactory<T> field(String field) {
        target.setField(field);
        return this;
    }

    public TargetFactory<T> dataExtractor(DataExtractor<T> dataExtractor) {
        target.setDataExtractor(dataExtractor);
        return this;
    }

    public TargetFactory<T> listDataExtractor(DataExtractor<List<T>> dataExtractor) {
        target.setListDataExtractor(dataExtractor);
        return this;
    }

    public TargetFactory<T> mapDataExtractor(DataExtractor<Map<String, T>> dataExtractor) {
        target.setMapDataExtractor(dataExtractor);
        return this;
    }

    public TargetFactory<T> cls(Class<T> cls) {
        target.setCls(cls);
        return this;
    }

    public TargetFactory<T> expireTimeInSecond(int expireTimeInSecond) {
        target.setExpireTimeInSecond(expireTimeInSecond);
        return this;
    }

    public TargetFactory<T> selector(int selector) {
        target.setSelector(selector);
        return this;
    }

    public TargetFactory<T> batchSize(int batchSize) {
        target.setBatchSize(batchSize);
        return this;
    }

    public TargetFactory<T> skipNativeCache(boolean skipNativeCache) {
        target.setSkipNativeCache(skipNativeCache);
        return this;
    }
}
