/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import com.bxm.warcar.utils.LifeCycle;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalClient
extends LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanalClient.class);
    private static final String FILTER_DEFAULT = ".*\\..*";
    private static final int BATCH_SIZE = 1000;
    private final String zkServers;
    private final String destination;
    private final String username;
    private final String password;
    private String filter = ".*\\..*";
    private int batchSize = 1000;
    private CanalConnector connector;

    public CanalClient(String zkServers, String destination) {
        this(zkServers, destination, null, null);
    }

    public CanalClient(String zkServers, String destination, String username, String password) {
        this.zkServers = zkServers;
        this.destination = destination;
        this.username = username;
        this.password = password;
    }

    protected void doInit() {
        this.connector = CanalConnectors.newClusterConnector((String)this.zkServers, (String)this.destination, (String)this.username, (String)this.password);
        try {
            this.connector.connect();
            this.connector.subscribe(this.filter);
            this.connector.rollback();
            while (true) {
                boolean empty;
                Message message = this.connector.getWithoutAck(this.batchSize, Long.valueOf(0L), TimeUnit.MILLISECONDS);
                long messageId = message.getId();
                List entries = message.getEntries();
                int size = entries.size();
                boolean bl = empty = messageId == -1L || size == 0;
                if (!empty) continue;
            }
        }
        catch (CanalClientException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("doInit:", (Throwable)e);
            }
            return;
        }
    }

    protected void doDestroy() {
        this.connector.disconnect();
    }

    public String getZkServers() {
        return this.zkServers;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

