package com.bxm.warcar.canal.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.bxm.warcar.canal.annotation.FieldMapper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @since 1.0.0
 */
public final class EntityHelper {

    private static final Logger LOGGER = LoggerFactory.getLogger(EntityHelper.class);

    private EntityHelper() {}

    public static <T> T consutract(List<CanalEntry.Column> columns, Class<T> cls) {
        if (CollectionUtils.isEmpty(columns)) {
            return null;
        }

        Map<String, Object> data = Maps.newHashMap();
        for (CanalEntry.Column column : columns) {
            String name = column.getName();
            String value = column.getValue();
            data.put(name, value);
        }
        try {
            return consutract(data, cls);
        } catch (IllegalAccessException | InstantiationException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("consutract: ", e);
            }
            return null;
        }
    }

    public static <T> T consutract(Map<String, Object> data, Class<T> cls) throws IllegalAccessException, InstantiationException {
        T t = cls.newInstance();

        Field[] fields = cls.getDeclaredFields();
        for (Field field : fields) {
            // if the field name is 'appId'
            Class<?> type = field.getType();
            String fieldName = field.getName();
            String paramName = fieldName;
            if (field.isAnnotationPresent(FieldMapper.class)) {
                paramName = field.getAnnotation(FieldMapper.class).value();
            }
            // select appId node
            Object current = data.get(paramName);
            if (null == current) {
                // select appid node
                current = data.get(paramName.toLowerCase());
            }
            if (null == current) {
                // select APPID node
                current = data.get(paramName.toUpperCase());
            }
            if (null == current) {
                // select app_id node
                String nodename = StringUtils.join(StringUtils.splitByCharacterTypeCamelCase(paramName), "_").toLowerCase();
                current = data.get(nodename);
            }
            if (null == current) {
                // select APP_ID node
                String nodename = StringUtils.join(StringUtils.splitByCharacterTypeCamelCase(paramName), "_").toUpperCase();
                current = data.get(nodename);
            }
            if (null != current) {
                String invokeName = StringUtils.join(new String[] { "set", StringUtils.capitalize(fieldName) });
                try {
                    MethodUtils.invokeMethod(t, invokeName, TypeHelper.cast(current, type, ParserConfig.getGlobalInstance()));
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("NoSuchMethod-" + invokeName);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("IllegalAccess-" + invokeName);
                }
                catch (InvocationTargetException e) {
                    LOGGER.warn("InvocationTarget-" + invokeName);
                } catch (NullPointerException ignore) {
                } catch (NumberFormatException e) {
                    LOGGER.warn("NumberFormatException-" + e.getMessage());
                }
            }
        }
        return t;
    }
}
