/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.canal.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.bxm.warcar.canal.annotation.FieldMapper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityHelper.class);

    private EntityHelper() {
    }

    public static <T> T consutract(List<CanalEntry.Column> columns, Class<T> cls) {
        if (CollectionUtils.isEmpty(columns)) {
            return null;
        }
        HashMap data = Maps.newHashMap();
        for (CanalEntry.Column column : columns) {
            String name = column.getName();
            String value = column.getValue();
            data.put(name, value);
        }
        try {
            return EntityHelper.consutract(data, cls);
        }
        catch (IllegalAccessException | InstantiationException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("consutract: ", (Throwable)e);
            }
            return null;
        }
    }

    public static <T> T consutract(Map<String, Object> data, Class<T> cls) throws IllegalAccessException, InstantiationException {
        Field[] fields;
        T t = cls.newInstance();
        for (Field field : fields = cls.getDeclaredFields()) {
            String nodename;
            Object current;
            String fieldName;
            Class<?> type = field.getType();
            String paramName = fieldName = field.getName();
            if (field.isAnnotationPresent(FieldMapper.class)) {
                paramName = field.getAnnotation(FieldMapper.class).value();
            }
            if (null == (current = data.get(paramName))) {
                current = data.get(paramName.toLowerCase());
            }
            if (null == current) {
                current = data.get(paramName.toUpperCase());
            }
            if (null == current) {
                nodename = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)paramName), (String)"_").toLowerCase();
                current = data.get(nodename);
            }
            if (null == current) {
                nodename = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)paramName), (String)"_").toUpperCase();
                current = data.get(nodename);
            }
            if (null == current) continue;
            String invokeName = StringUtils.join((Object[])new String[]{"set", StringUtils.capitalize((String)fieldName)});
            try {
                MethodUtils.invokeMethod(t, (String)invokeName, (Object)TypeHelper.cast((Object)current, type, (ParserConfig)ParserConfig.getGlobalInstance()));
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("NoSuchMethod-" + invokeName);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("IllegalAccess-" + invokeName);
            }
            catch (InvocationTargetException e) {
                LOGGER.warn("InvocationTarget-" + invokeName);
            }
            catch (NullPointerException ignore) {
            }
            catch (NumberFormatException e) {
                LOGGER.warn("NumberFormatException-" + e.getMessage());
            }
        }
        return t;
    }
}

