package com.bxm.warcar.canal;

/**
 * @author allen
 * @since 1.0.0
 */
public interface CanalEventListener<T extends CanalEntity> {

    void doInsert(T afterInsert);

    void doUpdate(T beforeUpdate, T afterUpdate);

    void doDelete(T beforeDelete);

    Class<T> getEntityClass();

    /**
     * 监听的Schema.表名
     * @return e.g. schema.table_a
     */
    String listening();
}
