/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.canal.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.warcar.canal.CanalEntity;
import com.bxm.warcar.canal.CanalEventListener;
import com.bxm.warcar.canal.CanalEventType;
import com.bxm.warcar.canal.mq.CanalMessageBody;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalMessageListenerDispatcher
implements SingleMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanalMessageListenerDispatcher.class);
    private final String topic;
    private final String consumerId;
    private final Map<String, CanalEventListener<? extends CanalEntity>> listeners = Maps.newHashMap();

    public CanalMessageListenerDispatcher(String topic, String consumerId, CanalEventListener<? extends CanalEntity> ... listeners) {
        this.topic = topic;
        this.consumerId = consumerId;
        if (ArrayUtils.isNotEmpty((Object[])listeners)) {
            for (CanalEventListener<? extends CanalEntity> listener : listeners) {
                this.listeners.put(listener.listening(), listener);
            }
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public ConsumeStatus consume(Message message, Object context) {
        byte[] body = message.getBody();
        if (ArrayUtils.isEmpty((byte[])body)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("[{}] message body has be null.", (Object)message.getMsgId());
            }
            return ConsumeStatus.CONSUME_SUCCESS;
        }
        try {
            CanalMessageBody entity = (CanalMessageBody)JSONObject.parseObject((byte[])body, CanalMessageBody.class, (Feature[])new Feature[0]);
            String tags = message.getTags();
            CanalEventListener<? extends CanalEntity> listener = this.listeners.get(tags);
            this.doConsume(entity, listener);
            return ConsumeStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("[" + message.getMsgId() + "] message consume fail.", (Throwable)e);
            }
            return ConsumeStatus.RECONSUME_LATER;
        }
    }

    private <T extends CanalEntity> void doConsume(CanalMessageBody entity, CanalEventListener<T> listener) {
        if (null == listener) {
            return;
        }
        CanalEventType canalEventType = entity.getCanalEventType();
        T after = this.forceConvert(entity.getAfter(), listener);
        T before = this.forceConvert(entity.getBefore(), listener);
        if (canalEventType == CanalEventType.INSERT) {
            listener.doInsert(before);
        } else if (canalEventType == CanalEventType.DELETE) {
            listener.doDelete(before);
        } else if (canalEventType == CanalEventType.UPDATE) {
            listener.doUpdate(before, after);
        }
    }

    private <T extends CanalEntity> T forceConvert(Object obj, CanalEventListener<T> listener) {
        if (null != obj && obj instanceof JSON) {
            return (T)((CanalEntity)JSONObject.toJavaObject((JSON)((JSON)obj), listener.getEntityClass()));
        }
        return null;
    }

    public Map<String, CanalEventListener<? extends CanalEntity>> getListeners() {
        return this.listeners;
    }
}

