package com.bxm.warcar.configure.test;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @since 2019-12-23
 */
@SpringBootApplication
@EnableConfigurationProperties(ConfigureProperties.class)
public class ConfigureApplication {

    @Bean
    @RefreshScope
    public Configures configures(ConfigureProperties properties) {
        return new Configures(properties.getDemo());
    }

    public static void main(String[] args) {
        SpringApplication.run(ConfigureApplication.class, args);
    }
}
