/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.configure.loader.zk;

import com.bxm.warcar.configure.loader.AbstractEnvironmentLoader;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <h3>ZooKeeper configure loader implementation</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/21
 */
public class ZooKeeperEnvironmentLoader extends AbstractEnvironmentLoader {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperEnvironmentLoader.class);

    private ZooKeeperHolder zooKeeperHolder;

    public ZooKeeperEnvironmentLoader(String address, String[] keys) {
        super(address, keys);
        this.zooKeeperHolder = new ZooKeeperHolder(addresses);
        this.zooKeeperHolder.init();
    }

    @Override
    protected byte[] readSource(String key) {
        CuratorFramework client = zooKeeperHolder.getClient();
        try {
            return client.getData().forPath(key);
        } catch (Exception e) {
            if (LOGGER.isWarnEnabled())
                LOGGER.warn("loadProperties:", e);
            return null;
        }
    }

    @Override
    public void destroy() {
        if (null != zooKeeperHolder) {
            zooKeeperHolder.destroy();
        }
    }
}
