/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.configure.loader;

import com.bxm.warcar.configure.EnvironmentLoader;
import com.bxm.warcar.configure.loader.zk.ZooKeeperEnvironmentLoader;
import org.apache.commons.lang.StringUtils;

/**
 * <h3>Environment loader factory</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/21
 */
public final class EnvironmentLoaderFactory {

    public static final String ZOOKEEPER_ADDRESS_PREFIX = "zookeeper://";

    private EnvironmentLoaderFactory() {}

    public static EnvironmentLoader create(String address, String key) {

        String[] keys = StringUtils.split(key, ',');

        if (StringUtils.startsWithIgnoreCase(address, ZOOKEEPER_ADDRESS_PREFIX)) {
            return new ZooKeeperEnvironmentLoader(StringUtils.removeStartIgnoreCase(address, ZOOKEEPER_ADDRESS_PREFIX), keys);
        }
        return null;
    }
}
