/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.configure.loader;

import com.bxm.warcar.configure.EnvironmentLoader;
import com.bxm.warcar.configure.PropertiesReader;
import com.bxm.warcar.configure.reader.PropertiesReaderFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Properties;

/**
 * <h3>abstract environment loader.</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/21
 */
public abstract class AbstractEnvironmentLoader implements EnvironmentLoader {

    protected final String addresses;
    protected final String[] keys;

    public AbstractEnvironmentLoader(String address, String[] keys) {
        Preconditions.checkArgument(StringUtils.isNotBlank(address));
        Preconditions.checkArgument(null != keys);
        this.addresses = address;
        this.keys = keys;
    }

    protected abstract byte[] readSource(String key);

    @Override
    public List<Properties> loadProperties() {
        List<Properties> properties = Lists.newArrayList();
        for (String key : keys) {
            byte[] bytes = readSource(key);
            if (null == bytes || bytes.length == 0)
                continue;

            PropertiesReader reader = PropertiesReaderFactory.create(key);
            properties.add(reader.read(bytes));
        }
        return properties;
    }
}
