package com.bxm.warcar.datasync.client.actions;

import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public class CacheAction implements Action {

    private static final Logger LOGGER = LoggerFactory.getLogger(CacheAction.class);
    private final MutableCache mutableCache;

    public CacheAction(MutableCache mutableCache) {
        Preconditions.checkNotNull(mutableCache);
        this.mutableCache = mutableCache;
    }

    @Override
    public void add(String key, Object value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "value");
        mutableCache.set(key, value);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("added cache: {}", key);
        }
    }

    @Override
    public void update(String key, Object value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "value");
        mutableCache.set(key, value);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("updated cache: {}", key);
        }
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank(key)) {
            return;
        }
        mutableCache.del(key);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("deleted cache: {}", key);
        }
    }
}
