package com.bxm.warcar.datasync.client.cache;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;
import java.util.concurrent.ExecutionException;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public class LoadingCacheImpl implements MutableCache {

    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingCacheImpl.class);
    private final LoadingCache<String, Optional<Object>> cache = CacheBuilder.newBuilder().build(new CacheLoader<String, Optional<Object>>() {
        @Override
        public Optional<Object> load(String key) throws Exception {
            return Optional.empty();
        }
    });

    @Override
    public Object set(String key, Object value) throws NullPointerException {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        Preconditions.checkNotNull(value, "value");

        String old = this.get(key);
        try {
            Optional<Object> optional = Optional.of(value);
            cache.put(key, optional);
        } catch (Exception e) {
            LOGGER.error("set: ", e);
        }
        return old;
    }

    @Override
    public void del(String key) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        try {
            cache.refresh(key);
        } catch (Exception e) {
            LOGGER.error("del: ", e);
        }
    }

    @Override
    public <T> T get(String key) throws NullPointerException {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        try {
            Optional<Object> optional = cache.get(key);
            return (T) optional.orElse(null);
        } catch (ExecutionException e) {
            LOGGER.error("cache get: ", e);
        } catch (Exception e) {
            LOGGER.error("get: ", e);
        }
        return null;
    }
}
