package com.bxm.warcar.datasync.client.cache;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public interface MutableCache extends Cache {

    /**
     * 设置对象到缓存中
     * @param key 保存的key
     * @param value value
     * @return 返回修改前的旧对象
     */
    Object set(String key, Object value) throws NullPointerException;

    /**
     * 清空指定key的缓存
     * @param key key
     */
    void del(String key);
}
