package com.bxm.warcar.datasync.client.actions;

import com.bxm.warcar.datasync.client.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public class EchoAction implements Action {

    private static final Logger LOGGER = LoggerFactory.getLogger(EchoAction.class);

    @Override
    public void add(String key, Object value) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("added: {}={}", key, value);
        }
    }

    @Override
    public void update(String key, Object value) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("updated: {}={}", key, value);
        }
    }

    @Override
    public void remove(String key) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("removed: {}", key);
        }
    }
}
