package com.bxm.warcar.datasync.server.sync;

import com.bxm.warcar.utils.JsonHelper;

import java.io.Serializable;

/**
 * @author allen
 * @date 2019/4/2
 * @since 1.0.0
 */
public class SyncCache implements Serializable {

    private static final long serialVersionUID = -208814780877255741L;

    private String id;
    private Class<?> cls;

    public byte[] toByte() {
        return JsonHelper.convert2bytes(this);
    }

    public static SyncCache of(byte[] data) {
        return JsonHelper.convert(data, SyncCache.class);
    }

    public SyncCache(String id, Class<?> cls) {
        this.id = id;
        this.cls = cls;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getCls() {
        return cls;
    }

    public void setCls(Class<?> cls) {
        this.cls = cls;
    }
}
