/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.source.redis;

import com.bxm.warcar.datasync.source.SourceController;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisSourceController
implements SourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSourceController.class);
    public static final String DEFAULT_PREFIX_KEY = "warcar:data:sync:";
    private final JedisPool jedisPool;
    private final String prefixKey;
    private final int db;

    public RedisSourceController(JedisPool jedisPool) {
        this(jedisPool, DEFAULT_PREFIX_KEY, 0);
    }

    public RedisSourceController(JedisPool jedisPool, String prefixKey, int db) {
        Preconditions.checkNotNull((Object)jedisPool);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)prefixKey));
        this.prefixKey = prefixKey;
        this.db = db;
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(String key, String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"value");
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (this.db > 0) {
                jedis.select(this.db);
            }
            boolean bl = StringUtils.equalsIgnoreCase((String)jedis.set(this.prefixKey + key, value), (String)"OK");
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("set: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (this.db > 0) {
                jedis.select(this.db);
            }
            String string = jedis.get(this.prefixKey + key);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("get: ", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (this.db > 0) {
                jedis.select(this.db);
            }
            jedis.del(this.prefixKey + key);
        }
        catch (Exception e) {
            LOGGER.error("del: ", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

