package com.bxm.warcar.dpl.test;

import com.bxm.warcar.dpl.test.common.DemoRequest;
import com.bxm.warcar.dpl.test.common.DemoService;
import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.plugin.Plugin;
import com.bxm.warcar.dpl2.plugin.spring.SpringPlugin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author allen
 * @date 2019/6/28
 * @since 1.0.0
 */
@RestController
public class DplController {

    private final PluginBus pluginBus;

    public DplController(PluginBus pluginBus) {
        this.pluginBus = pluginBus;
    }

    @RequestMapping("/handle")
    public String handle(@RequestParam String key) {
        Plugin plugin = pluginBus.lookup(key);
        DemoService service = plugin.getService(DemoService.class);
        return service.handle(new DemoRequest()).getName();
    }
}
