/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2;

import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.plugin.Plugin;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginBus
implements PluginBus {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginBus.class);
    private final ConcurrentMap<String, Plugin> pluginHolder = Maps.newConcurrentMap();

    @Override
    public void register(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin);
        String key = plugin.getConfig().getKey();
        Plugin old = this.pluginHolder.putIfAbsent(key, plugin);
        if (null != old) {
            throw new RuntimeException("Plugin[" + key + "] has existed, ignore.");
        }
        log.debug("Plugin[{}] has registered successful.", (Object)key);
    }

    @Override
    public void unregister(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin);
        String key = plugin.getConfig().getKey();
        Plugin removed = (Plugin)this.pluginHolder.remove(key);
        if (null != removed) {
            log.debug("Plugin[{}] has unregistered successful.", (Object)key);
        } else {
            log.debug("No plugin for {}", (Object)key);
        }
    }

    @Override
    public Iterator<Plugin> getAllPlugins() {
        return this.pluginHolder.values().iterator();
    }

    @Override
    public Plugin lookup(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key));
        Plugin plugin = (Plugin)this.pluginHolder.get(key);
        if (null == plugin) {
            log.debug("Can not found plugin for {}", (Object)key);
        }
        return plugin;
    }
}

