/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginConfig;
import com.bxm.warcar.dpl.PluginLoader;
import com.bxm.warcar.dpl.hotswap.PluginClassLoader2;
import com.bxm.warcar.dpl.impl.PluginApplicationContext;
import com.bxm.warcar.dpl.impl.SpringPlugin;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class PluginLoaderImpl
implements PluginLoader,
ApplicationContextAware {
    private static final String DEFAULT_BASE_PACKAGE = "com.bxm.warcar.plugins";
    private ApplicationContext applicationContext;
    private List<Class<? extends Annotation>> loadClasses;

    public void setLoadClasses(List<Class<? extends Annotation>> loadClasses) {
        this.loadClasses = loadClasses;
    }

    @Override
    public Plugin load(PluginConfig pluginConfig) {
        PluginApplicationContext pluginApplication = this.loadPluginApplication(pluginConfig);
        return new SpringPlugin(pluginConfig, pluginApplication);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private PluginApplicationContext loadPluginApplication(PluginConfig pluginConfig) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        PluginClassLoader2 pluginClassLoader2 = new PluginClassLoader2(pluginConfig.getJarPath(), this.applicationContext.getClassLoader());
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader2);
            PluginApplicationContext pluginApplicationContext = new PluginApplicationContext();
            List<Class<?>> classes = pluginClassLoader2.searchClasses(DEFAULT_BASE_PACKAGE, clazz -> {
                for (Class<? extends Annotation> loadClass : this.loadClasses) {
                    if (!clazz.isAnnotationPresent(loadClass)) continue;
                    return true;
                }
                return false;
            });
            pluginApplicationContext.setParent(this.applicationContext);
            pluginApplicationContext.register(classes.toArray(new Class[0]));
            pluginApplicationContext.setClassLoader(pluginClassLoader2);
            pluginApplicationContext.refresh();
            Map<RequestMappingInfo, HandlerMethod> thisMappings = this.register2RequestMapping(pluginApplicationContext, classes);
            pluginApplicationContext.setMappings(thisMappings);
            PluginApplicationContext pluginApplicationContext2 = pluginApplicationContext;
            return pluginApplicationContext2;
        }
        catch (Throwable e) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)pluginClassLoader2);
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private Map<RequestMappingInfo, HandlerMethod> register2RequestMapping(PluginApplicationContext pluginApplicationContext, List<Class<?>> classes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        AbstractHandlerMethodMapping requestMappingHandlerMapping = (AbstractHandlerMethodMapping)this.applicationContext.getBean(AbstractHandlerMethodMapping.class);
        Method detectHandlerMethods = AbstractHandlerMethodMapping.class.getDeclaredMethod("detectHandlerMethods", Object.class);
        detectHandlerMethods.setAccessible(true);
        Map beans = pluginApplicationContext.getBeansWithAnnotation(RestController.class);
        Set entries = beans.entrySet();
        for (Map.Entry entry : entries) {
            detectHandlerMethods.invoke((Object)requestMappingHandlerMapping, entry.getValue());
        }
        HashMap thisMappings = Maps.newHashMap();
        Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
        Set mappings = handlerMethods.entrySet();
        for (Map.Entry mapping : mappings) {
            RequestMappingInfo mappingInfo = (RequestMappingInfo)mapping.getKey();
            HandlerMethod method = (HandlerMethod)mapping.getValue();
            for (Class<?> cls : classes) {
                if (!method.getBeanType().equals(cls)) continue;
                thisMappings.put(mappingInfo, method);
            }
        }
        return thisMappings;
    }
}

