/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2.dir;

import com.bxm.warcar.dpl2.dir.Snapshot;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.Map;

public class PluginChangedEvent
extends EventObject {
    private static final long serialVersionUID = 1790843367218320922L;
    private final List<String> added = Lists.newArrayList();
    private final List<String> updated = Lists.newArrayList();
    private final List<String> removed = Lists.newArrayList();
    private final List<String> all = Lists.newArrayList();

    public PluginChangedEvent(Object source, Snapshot old, Snapshot currently) {
        super(source);
        Preconditions.checkNotNull((Object)currently);
        this.init(old, currently);
    }

    private void init(Snapshot old, Snapshot currently) {
        if (null == old) {
            this.added.addAll(currently.getFiles().keySet());
        } else {
            String filename;
            Map<String, Long> oldFiles = old.getFiles();
            Map<String, Long> currentlyFiles = currently.getFiles();
            for (Map.Entry<String, Long> e : oldFiles.entrySet()) {
                filename = e.getKey();
                long modifyTime = e.getValue();
                if (!currentlyFiles.containsKey(filename)) {
                    this.removed.add(filename);
                    continue;
                }
                if (modifyTime == currentlyFiles.get(filename)) continue;
                this.updated.add(filename);
            }
            for (Map.Entry<String, Long> e : currentlyFiles.entrySet()) {
                filename = e.getKey();
                if (oldFiles.containsKey(filename)) continue;
                this.added.add(filename);
            }
        }
        this.all.addAll(currently.getFiles().keySet());
    }

    public List<String> getAdded() {
        return this.added;
    }

    public List<String> getUpdated() {
        return this.updated;
    }

    public List<String> getRemoved() {
        return this.removed;
    }

    public List<String> getAll() {
        return this.all;
    }

    @Override
    public String toString() {
        return "PluginChangedEvent(added=" + this.getAdded() + ", updated=" + this.getUpdated() + ", removed=" + this.getRemoved() + ", all=" + this.getAll() + ")";
    }
}

