/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2.hotswap;

import com.bxm.warcar.dpl.PluginRuntimeException;
import com.bxm.warcar.dpl2.hotswap.PluginClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class PluginResourceURLStreamHandler
extends URLStreamHandler {
    private static final String DEFAULT_PROTOCOL = "pluginresource:";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private final PluginClassLoader pluginClassLoader;

    public PluginResourceURLStreamHandler(PluginClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        String protocol = u.getProtocol();
        if (!this.valid(protocol)) {
            throw new PluginRuntimeException("Invalid protocol, expect " + PluginResourceURLStreamHandler.getProtocol() + ", but " + protocol);
        }
        final String resource = u.getPath();
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public String getContentType() {
                FileNameMap fileNameMap = URLConnection.getFileNameMap();
                String contentType = fileNameMap.getContentTypeFor(resource);
                if (null == contentType) {
                    contentType = PluginResourceURLStreamHandler.DEFAULT_CONTENT_TYPE;
                }
                return contentType;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                InputStream is = PluginResourceURLStreamHandler.this.pluginClassLoader.getByteInputStream(resource);
                if (null == is) {
                    throw new IOException("PluginClassLoader.getByteInputStream() returned null for " + resource);
                }
                return is;
            }
        };
    }

    static String getProtocol() {
        return DEFAULT_PROTOCOL;
    }

    private boolean valid(String protocol) {
        String defaultProtocol = PluginResourceURLStreamHandler.getProtocol();
        return protocol.equals(defaultProtocol.substring(0, defaultProtocol.length() - 1));
    }
}

