/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginConfig;
import com.bxm.warcar.dpl.PluginLoader;
import com.bxm.warcar.dpl.hotswap.PluginClassLoader2;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
public class PluginLoaderImpl implements PluginLoader, ApplicationContextAware {

    private static final String DEFAULT_BASE_PACKAGE = "com.bxm.warcar.plugins";

    private ApplicationContext applicationContext;

    private List<Class<? extends Annotation>> loadClasses;

    public void setLoadClasses(List<Class<? extends Annotation>> loadClasses) {
        this.loadClasses = loadClasses;
    }

    @Override
    public Plugin load(PluginConfig pluginConfig) {
        PluginApplicationContext pluginApplication = loadPluginApplication(pluginConfig);
        return new SpringPlugin(pluginConfig, pluginApplication);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private PluginApplicationContext loadPluginApplication(PluginConfig pluginConfig) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();

        PluginClassLoader2 pluginClassLoader2 = new PluginClassLoader2(pluginConfig.getJarPath(), applicationContext.getClassLoader());

        try {
            //把当前线程的ClassLoader切换成模块的
            Thread.currentThread().setContextClassLoader(pluginClassLoader2);

            PluginApplicationContext pluginApplicationContext = new PluginApplicationContext();

            List<Class<?>> classes = pluginClassLoader2.searchClasses(DEFAULT_BASE_PACKAGE, clazz -> {
                for (Class<? extends Annotation> loadClass : loadClasses) {
                    if (clazz.isAnnotationPresent(loadClass)) {
                        return true;
                    }
                }
                return false;
            });

            pluginApplicationContext.setParent(applicationContext);
            pluginApplicationContext.register(classes.toArray(new Class[0]));
            pluginApplicationContext.setClassLoader(pluginClassLoader2);
            pluginApplicationContext.refresh();

            // Register to RequestHandlerMethodMapping
            Map<RequestMappingInfo, HandlerMethod> thisMappings = register2RequestMapping(pluginApplicationContext, classes);
            pluginApplicationContext.setMappings(thisMappings);

            return pluginApplicationContext;
        } catch (Throwable e) {
            CachedIntrospectionResults.clearClassLoader(pluginClassLoader2);
            throw new RuntimeException(e);
        } finally {
            //还原当前线程的ClassLoader
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private Map<RequestMappingInfo, HandlerMethod> register2RequestMapping(PluginApplicationContext pluginApplicationContext, List<Class<?>> classes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        AbstractHandlerMethodMapping requestMappingHandlerMapping = applicationContext.getBean(AbstractHandlerMethodMapping.class);
        Method detectHandlerMethods = AbstractHandlerMethodMapping.class.getDeclaredMethod("detectHandlerMethods", Object.class);
        detectHandlerMethods.setAccessible(true);

        Map<String, Object> beans = pluginApplicationContext.getBeansWithAnnotation(RestController.class);
        Set<Map.Entry<String, Object>> entries = beans.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            detectHandlerMethods.invoke(requestMappingHandlerMapping, entry.getValue());
        }

        Map<RequestMappingInfo, HandlerMethod> thisMappings = Maps.newHashMap();
        Map<RequestMappingInfo, HandlerMethod> handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
        Set<Map.Entry<RequestMappingInfo, HandlerMethod>> mappings = handlerMethods.entrySet();
        for (Map.Entry<RequestMappingInfo, HandlerMethod> mapping : mappings) {
            RequestMappingInfo mappingInfo = mapping.getKey();
            HandlerMethod method = mapping.getValue();
            for (Class<?> cls : classes) {
                if (method.getBeanType().equals(cls)) {
                    thisMappings.put(mappingInfo, method);
                }
            }
        }
        return thisMappings;
    }
}
