package com.bxm.warcar.eventbus.test;

import com.bxm.warcar.integration.eventbus.EventPark;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author allen
 * @date 2020-11-13
 * @since 1.0
 */
@RestController
public class MyEventController {

    private final EventPark eventPark;

    public MyEventController(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @GetMapping("/post")
    public ResponseEntity<Object> post(long sleep, int loop) {
        for (int i = 0; i < loop; i++) {
            eventPark.post(new MyEvent(this, sleep));
        }
        return ResponseEntity.ok().build();
    }
}
