package com.bxm.warcar.eventbus.test;

import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * @author allen
 * @date 2020-11-13
 * @since 1.0
 */
@Slf4j
@Component
public class MyEventListener implements EventListener<MyEvent> {

    @Override
    @AllowConcurrentEvents
    @Subscribe
    public void consume(MyEvent event) {
        log.info("consume event!");

        try {
            Thread.sleep(event.getSleepTime());
        } catch (InterruptedException e) {
            ;
        }
    }
}
