/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.eventbus;

import com.bxm.warcar.integration.eventbus.AbstractEventPark;
import com.bxm.warcar.integration.eventbus.core.AsyncEventBus;
import com.bxm.warcar.integration.eventbus.core.EventBus;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncEventPark
extends AbstractEventPark {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncEventPark.class);
    private final AsyncEventBus asyncEventBus;
    private final ThreadPoolExecutor threadPoolExecutor;

    public AsyncEventPark() {
        this(Runtime.getRuntime().availableProcessors() * 2 + 1);
    }

    public AsyncEventPark(int coreSize) {
        this(new ThreadPoolExecutor(coreSize, coreSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("event-park")));
    }

    public AsyncEventPark(ThreadPoolExecutor executor) {
        this.threadPoolExecutor = executor;
        this.asyncEventBus = new AsyncEventBus("async-event-bus", executor);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ThreadPoolExecutor current core pool size is {}", (Object)executor.getCorePoolSize());
        }
    }

    @Override
    protected EventBus getEventBus() {
        return this.asyncEventBus;
    }

    @Override
    protected String getEventParkName() {
        return "AsyncEventPark";
    }

    public int getQueueSize() {
        return this.threadPoolExecutor.getQueue().size();
    }
}

