package com.bxm.warcar.integration.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <h3>抽象的消息监听器</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
public abstract class AbstractMessageListener implements SingleMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageListener.class);

    /**
     * 消费消息
     * @param message
     * @param request
     * @param returning
     */
    protected abstract void consume(Message message, Object request, Object returning);

    @Override
    public ConsumeStatus consume(Message message, Object context) {
        try {
            MessageBody body = JsonHelper.convert(message.getBody(), MessageBody.class);
            if (null == body) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not consume message {}-{}, because body cannot deserialize.", message.getTopic(), message.getMsgId());
                }
                return ConsumeStatus.RECONSUME_LATER;
            }

            Object request = body.getRequest();
            if (null != request && request instanceof JSON) {
                request = JSONObject.toJavaObject((JSON) request, body.getRequestClass());
            }

            Object returning = body.getReturning();
            if (null != returning && returning instanceof JSON) {
                returning = JSONObject.toJavaObject((JSON) body.getReturning(), body.getReturningClass());
            }

            consume(message, request, returning);

            return ConsumeStatus.CONSUME_SUCCESS;
        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("consume: ", e);
            }
            return ConsumeStatus.RECONSUME_LATER;
        }
    }
}
