package com.bxm.warcar.integration.pushable;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>缓存推送总控</p>
 * 如果需要将推送接收器集成到这个bus中，请将类实现{@linkplain Pushable}接口，并声明{@linkplain CachePush}
 *
 * @author allen
 * @date 2017-12-04
 */
public class CachePushableBus extends LifeCycle implements ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableBus.class);

    private ApplicationContext ctx;
    private final Map<String, Pushable> pushables = new HashMap<>();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
        this.init();
    }

    @Override
    protected void doInit() {
        Map<String, Pushable> beans = this.ctx.getBeansOfType(Pushable.class);
        for (Map.Entry<String, Pushable> entry : beans.entrySet()) {
            Pushable bean = entry.getValue();
            CachePush anno = bean.getClass().getAnnotation(CachePush.class);
            if (null != anno) {
                pushables.put(anno.value(), bean);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Registering bean to CachePushableBus: {}", bean);
                }
            }
        }
    }

    @Override
    protected void doDestroy() {
    }

    public Pushable getRefreshable(String serviceName) {
        if (!isInitialized()) {
            throw new RuntimeException("RefreshBus must be initialized.");
        }
        return pushables.get(serviceName);
    }
}
