/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.pushable;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public class CachePushableBus
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableBus.class);
    private final Map<String, Pushable> pushables = new HashMap<String, Pushable>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass = ClassUtils.getUserClass((Object)bean);
        CachePush anno = beanClass.getAnnotation(CachePush.class);
        if (null != anno) {
            if (!(bean instanceof Pushable)) {
                throw new BeanCreationException("Bean '" + beanName + "' must be implement Pushable!");
            }
            this.pushables.put(anno.value(), (Pushable)bean);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Registering bean to CachePushableBus: {}", bean);
            }
        }
        return bean;
    }

    public Pushable getRefreshable(String serviceName) {
        return this.pushables.get(serviceName);
    }
}

