/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.pushable.message;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.integration.pushable.CachePushableBus;
import com.bxm.warcar.integration.pushable.message.MessageEntity;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachePushableMessageListener
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableMessageListener.class);
    private String topic;
    private final CachePushableBus cachePushableBus;

    public CachePushableMessageListener(CachePushableBus cachePushableBus) {
        this(null, cachePushableBus);
    }

    public CachePushableMessageListener(String topic, CachePushableBus cachePushableBus) {
        Preconditions.checkNotNull((Object)cachePushableBus);
        this.topic = topic;
        this.cachePushableBus = cachePushableBus;
    }

    public String getTopic() {
        return this.topic;
    }

    protected MessageEntity convert(Object request) {
        return null;
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        MessageEntity entity = null;
        if (!(request instanceof MessageEntity)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("request object must be instance of com.bxm.warcar.integration.pushable.message.MessageEntity!");
            }
            if (null == (entity = this.convert(request))) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("You can override #convert(Object request)!");
                }
                return;
            }
        } else {
            entity = (MessageEntity)request;
        }
        String serviceName = entity.getServiceName();
        Map<String, Object> parameters = entity.getParameters();
        byte[] data = entity.getData();
        Pushable bean = this.cachePushableBus.getRefreshable(serviceName);
        if (null == bean) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting refresh cache, serviceName={}, parameters={}, data={}", new Object[]{serviceName, parameters, StringHelper.convert((byte[])data)});
        }
        long start = System.currentTimeMillis();
        bean.push(parameters, data);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache refreshed in {} ms. serviceName={}, parameters={}, data-length={}", new Object[]{System.currentTimeMillis() - start, serviceName, parameters, null == data ? 0 : data.length});
        }
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

