/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.zk;

import com.bxm.warcar.integration.distributed.DistributedLock;
import com.bxm.warcar.integration.distributed.DistributedLockBeanFactory;
import com.bxm.warcar.integration.distributed.DistributedLockBus;
import com.bxm.warcar.integration.distributed.zk.ZooKeeperDistributedLock;
import com.bxm.warcar.integration.distributed.zk.ZooKeeperDistributedPathUtils;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ClassUtils;

public class ZooKeeperDistributedLockBus
implements DistributedLockBus {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperDistributedLockBus.class);
    private final ConcurrentMap<String, ZooKeeperDistributedLock> locks = new ConcurrentHashMap<String, ZooKeeperDistributedLock>(64);
    private final ZkClientHolder zkClientHolder;

    public ZooKeeperDistributedLockBus(DistributedLockBeanFactory distributedLockBeanFactory, ZkClientHolder zkClientHolder) {
        Preconditions.checkNotNull((Object)zkClientHolder);
        this.zkClientHolder = zkClientHolder;
        Map<Method, Object> mapping = distributedLockBeanFactory.getMapping();
        for (Map.Entry<Method, Object> entry : mapping.entrySet()) {
            this.processScheduled(entry.getKey(), entry.getValue());
        }
    }

    private void processScheduled(Method method, Object bean) {
        String className = this.getClassName(bean);
        String path = ZooKeeperDistributedPathUtils.createPath(className, method);
        ZooKeeperDistributedLock lock = new ZooKeeperDistributedLock(this.zkClientHolder, path);
        if (this.locks.containsKey(path)) {
            throw new RuntimeException("Distributed lock '" + path + "' for ZooKeeper already exist!");
        }
        this.locks.putIfAbsent(path, lock);
        logger.info("{} created distributed lock on bean {}", (Object)method, bean);
    }

    @Override
    public DistributedLock getLock(Object bean, Method method) {
        String path = ZooKeeperDistributedPathUtils.createPath(this.getClassName(bean), method);
        return (DistributedLock)this.locks.get(path);
    }

    private String getClassName(Object bean) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        String className = targetClass.getName();
        if (ClassUtils.isCglibProxy((Object)bean)) {
            className = StringUtils.split((String)className, (String)"$$")[0];
        }
        return className;
    }
}

