/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed;

import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class FirstTimeExecutor<T> {
    private final Counter counter;
    private final String executorName;
    private final Duration silentTime;
    private final Consumer<T> executor;

    public FirstTimeExecutor(Counter counter, String executorName, Duration silentTime) {
        this(counter, executorName, silentTime, null);
    }

    public FirstTimeExecutor(Counter counter, String executorName, Duration silentTime, Consumer<T> executor) {
        this.counter = counter;
        this.executorName = executorName;
        this.silentTime = silentTime;
        this.executor = executor;
    }

    public void submit(T t) {
        this.execute(t, this.executor);
    }

    public void execute(T t, Consumer<T> executor) {
        Objects.requireNonNull(executor);
        KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"warcar", "condition_executor", this.executorName});
        int expireTimeInSecond = (int)this.silentTime.getSeconds();
        Long after = this.counter.incrementAndGet(key, expireTimeInSecond, (Predicate)new Predicate<Long>(){

            @Override
            public boolean test(Long after) {
                return after == 1L;
            }
        });
        if (after == 1L) {
            executor.accept(t);
        }
    }
}

