/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.zk;

import com.bxm.warcar.integration.distributed.DistributedLock;
import com.bxm.warcar.zk.ZkClientHolder;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperDistributedLock
implements DistributedLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperDistributedLock.class);
    private final ZkClientHolder zkClientHolder;
    private final InterProcessLock lock;

    public ZooKeeperDistributedLock(ZkClientHolder zkClientHolder, String path) {
        this.zkClientHolder = zkClientHolder;
        this.lock = new InterProcessMutex(zkClientHolder.get(), path);
    }

    @Override
    public boolean acquire() {
        return this.acquire(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) {
        try {
            return this.lock.acquire(time, unit);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void release() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            LOGGER.error("release: ", (Throwable)e);
        }
    }
}

