package com.bxm.warcar.integration.distributed;

import java.util.concurrent.TimeUnit;

/**
 * 分布式锁
 *
 * @author allen
 * @since 1.0.0
 */
public interface DistributedLock {

    /**
     * Acquire the mutex - blocking until it's available. Each call to acquire must be balanced by a call
     * to {@link #release()}
     * @return true if the mutex was acquired, false if not
     *
     */
    boolean acquire();

    /**
     * Acquire the mutex - blocks until it's available or the given time expires. Each call to acquire that returns true must be balanced by a call
     * to {@link #release()}
     *
     * @param time time to wait
     * @param unit time unit
     * @return true if the mutex was acquired, false if not
     */
    boolean acquire(long time, TimeUnit unit);

    /**
     * Perform one release of the mutex.
     *
     */
    void release();
}
