/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.leader;

import com.bxm.warcar.integration.distributed.leader.LeaderLatchExecutor;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class LeaderLatchExecutorBeanFactory
implements BeanPostProcessor,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(LeaderLatchExecutorBeanFactory.class);
    private final ZkClientHolder zkClientHolder;
    private final List<LeaderLatch> leaderLatchList = Lists.newArrayList();

    public LeaderLatchExecutorBeanFactory(ZkClientHolder zkClientHolder) {
        this.zkClientHolder = zkClientHolder;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        boolean assignableFrom = LeaderLatchExecutor.class.isAssignableFrom(targetClass);
        if (assignableFrom) {
            LeaderLatchExecutor leaderLatchExecutor = (LeaderLatchExecutor)bean;
            this.createLeaderLatchAndStart(leaderLatchExecutor);
        }
        return bean;
    }

    @Override
    public void close() {
        this.leaderLatchList.forEach(e -> {
            try {
                e.close();
            }
            catch (IOException ex) {
                log.error("LeaderLatch close error", (Throwable)ex);
            }
        });
    }

    private void createLeaderLatchAndStart(final LeaderLatchExecutor leaderLatchExecutor) {
        String className = leaderLatchExecutor.getClass().getName();
        LeaderLatch leaderLatch = new LeaderLatch(this.zkClientHolder.get(), "/warcar/leader-latch/" + className);
        leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                try {
                    leaderLatchExecutor.execute();
                }
                catch (Exception e) {
                    log.error("LeaderLatchExecutor execute error", (Throwable)e);
                }
            }

            public void notLeader() {
            }
        });
        this.leaderLatchList.add(leaderLatch);
        try {
            leaderLatch.start();
            log.info("LeaderLatch {} start success", (Object)className);
        }
        catch (Exception e) {
            log.error("LeaderLatch start error", (Throwable)e);
        }
    }
}

