/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.scheduler;

import com.bxm.warcar.integration.distributed.DistributedLock;
import com.bxm.warcar.integration.distributed.FirstTimeExecutor;
import com.bxm.warcar.integration.distributed.scheduler.AtomicOnceScheduler;
import com.bxm.warcar.integration.distributed.scheduler.DistributedScheduler;
import com.bxm.warcar.integration.distributed.scheduler.LockScheduler;
import com.bxm.warcar.integration.distributed.scheduler.Scheduler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class ThreadPoolTaskDistributedScheduler
implements DistributedScheduler {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolTaskDistributedScheduler.class);
    private final ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
    private final Map<String, ScheduledFuture<?>> scheduledFutures = new ConcurrentHashMap();

    public ThreadPoolTaskDistributedScheduler(int poolSize) {
        this.threadPoolTaskScheduler.setPoolSize(poolSize);
        this.threadPoolTaskScheduler.initialize();
    }

    @Override
    public void schedule(Scheduler scheduler) {
        String name = scheduler.name();
        Runnable taskRunnable = scheduler.taskRunnable();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name must not be blank");
        Preconditions.checkNotNull((Object)taskRunnable, (Object)"taskRunnable must not be null");
        if (this.scheduledFutures.containsKey(name)) {
            log.warn("scheduler {} already scheduled", (Object)name);
            return;
        }
        ScheduledFuture future = this.threadPoolTaskScheduler.schedule(() -> {
            if (scheduler instanceof LockScheduler) {
                this.scheduleLockScheduler((LockScheduler)scheduler);
            } else if (scheduler instanceof AtomicOnceScheduler) {
                this.scheduleAtomicOnceScheduler((AtomicOnceScheduler)scheduler);
            } else {
                this.scheduleScheduler(scheduler);
            }
        }, triggerContext -> {
            CronTrigger cronTrigger = new CronTrigger(scheduler.cron());
            return cronTrigger.nextExecutionTime(triggerContext);
        });
        this.scheduledFutures.put(name, future);
        log.info("scheduler {} scheduled", (Object)name);
    }

    @Override
    public void cancel(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name must not be blank");
        ScheduledFuture<?> future = this.scheduledFutures.remove(name);
        if (null != future) {
            future.cancel(true);
            log.info("scheduler {} cancelled", (Object)name);
        }
    }

    private void scheduleScheduler(Scheduler scheduler) {
        Runnable taskRunnable = scheduler.taskRunnable();
        Class targetClass = AopUtils.getTargetClass((Object)scheduler);
        try {
            log.debug("scheduled task {} acquired lock and run", (Object)targetClass.getName());
            taskRunnable.run();
        }
        catch (Exception e) {
            log.error("scheduled task {} failed", (Object)targetClass.getName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLockScheduler(LockScheduler lockScheduler) {
        Runnable taskRunnable = lockScheduler.taskRunnable();
        DistributedLock distributedLock = lockScheduler.distributedLock();
        long idleTime = lockScheduler.idleTime();
        Class targetClass = AopUtils.getTargetClass((Object)lockScheduler);
        boolean acquired = false;
        try {
            acquired = distributedLock.acquire();
            if (acquired) {
                log.debug("scheduled task {} acquired lock and run", (Object)targetClass.getName());
                taskRunnable.run();
            }
        }
        catch (Exception e) {
            log.error("scheduled task {} failed", (Object)targetClass.getName(), (Object)e);
        }
        finally {
            try {
                Thread.sleep(idleTime);
            }
            catch (InterruptedException e) {
                log.error("scheduled task {} sleep interrupted", (Object)targetClass.getName(), (Object)e);
            }
            if (acquired) {
                distributedLock.release();
            }
        }
    }

    private void scheduleAtomicOnceScheduler(AtomicOnceScheduler atomicOnceScheduler) {
        final Runnable taskRunnable = atomicOnceScheduler.taskRunnable();
        FirstTimeExecutor<Object> firstTimeExecutor = atomicOnceScheduler.firstTimeExecutor();
        final Class targetClass = AopUtils.getTargetClass((Object)atomicOnceScheduler);
        try {
            firstTimeExecutor.execute(new Object(), new Consumer<Object>(){

                @Override
                public void accept(Object o) {
                    log.debug("scheduled task {} first time run", (Object)targetClass.getName());
                    taskRunnable.run();
                }
            });
        }
        catch (Exception e) {
            log.error("scheduled task {} failed", (Object)targetClass.getName(), (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.threadPoolTaskScheduler.shutdown();
    }
}

