package com.bxm.warcar.integration.distributed.lock;

import com.bxm.warcar.integration.distributed.DistributedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

import java.util.concurrent.TimeUnit;

/**
 * @author Allen Hu
 * @date 2025/10/22
 */
public class RedissonDistributedLock implements DistributedLock {

    private final RLock lock;

    public RedissonDistributedLock(RedissonClient redissonClient, String lockName) {
        this.lock = redissonClient.getLock(lockName);
    }

    @Override
    public boolean acquire() {
        return lock.tryLock();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) {
        try {
            return lock.tryLock(time, unit);
        } catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void release() {
        lock.unlock();
    }
}
