/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed;

import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;

public class MultiTimeExecutor<T> {
    private final Counter counter;
    private final String executorName;
    private final Duration silentTime;
    private final int maxTimes;
    private final Consumer<T> executor;

    public MultiTimeExecutor(Counter counter, String executorName, Duration silentTime, int maxTimes) {
        this(counter, executorName, silentTime, maxTimes, null);
    }

    public MultiTimeExecutor(Counter counter, String executorName, Duration silentTime, int maxTimes, Consumer<T> executor) {
        this.counter = counter;
        this.executorName = executorName;
        this.silentTime = silentTime;
        this.maxTimes = maxTimes;
        this.executor = executor;
    }

    public void submit(T t) {
        this.execute(t, this.executor);
    }

    public void execute(T t, Consumer<T> executor) {
        Objects.requireNonNull(executor);
        KeyGenerator key = this.stringKey();
        int expireTimeInSecond = (int)this.silentTime.getSeconds();
        Long after = this.counter.incrementAndGet(key, expireTimeInSecond, value -> value <= (long)this.maxTimes);
        if (after != null && after <= (long)this.maxTimes) {
            try {
                executor.accept(t);
            }
            catch (Exception e) {
                this.rollback();
                throw e;
            }
        }
    }

    public void rollback() {
        KeyGenerator key = this.stringKey();
        this.counter.decrementAndGet(key);
    }

    private KeyGenerator stringKey() {
        return () -> KeyBuilder.build((Object[])new Object[]{"warcar", "condition_executor", this.executorName});
    }
}

