/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.delayed;

import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedTaskQueueTool<V>
extends LifeCycle {
    private static final Logger log = LoggerFactory.getLogger(DelayedTaskQueueTool.class);
    private final RBlockingQueue<V> blockingQueue;
    private final RDelayedQueue<V> delayedQueue;
    private final ThreadPoolExecutor consumerThread;
    private final Consumer<V> consumer;
    private final String taskName;
    private final AtomicBoolean stop = new AtomicBoolean(false);

    public DelayedTaskQueueTool(RedissonClient redissonClient, String taskName, Consumer<V> consumer) {
        this.taskName = taskName;
        this.blockingQueue = redissonClient.getBlockingQueue(taskName);
        this.delayedQueue = redissonClient.getDelayedQueue(this.blockingQueue);
        this.consumerThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory(String.format("delayed-%s-queue-tool", taskName)));
        this.consumer = consumer;
    }

    public void offer(V value, long delay, TimeUnit timeUnit) {
        this.delayedQueue.offer(value, delay, timeUnit);
    }

    public boolean remove(V value) {
        return this.delayedQueue.remove(value);
    }

    public void removeAll(V value) {
        boolean removed;
        while (removed = this.remove(value)) {
        }
    }

    public void clear() {
        this.delayedQueue.clear();
    }

    public int size() {
        return this.delayedQueue.size();
    }

    protected void doInit() {
        this.consumerThread.execute(() -> {
            while (true) {
                try {
                    while (!this.stop.get()) {
                        log.info("delayed {} queue tool start consume", (Object)this.taskName);
                        Object value = this.blockingQueue.take();
                        log.info("delayed {} queue tool consume value: {}", (Object)this.taskName, value);
                        this.consumer.accept(value);
                    }
                }
                catch (InterruptedException value) {
                    continue;
                }
                catch (Exception e) {
                    log.error("delayed {} queue tool consume error", (Object)this.taskName, (Object)e);
                    continue;
                }
                break;
            }
        });
        log.info("delayed {} queue tool init success", (Object)this.taskName);
    }

    protected void doDestroy() {
        this.stop.compareAndSet(false, true);
        this.consumerThread.shutdownNow();
        log.info("delayed {} queue tool shutdown success", (Object)this.taskName);
    }
}

