/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.delayed;

import com.bxm.warcar.integration.distributed.delayed.DelayedTaskExecutor;
import com.bxm.warcar.integration.distributed.delayed.LatestOnlyDelayedTaskQueueTool;
import com.bxm.warcar.utils.LifeCycle;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.redisson.api.RedissonClient;

public class LatestOnlyDelayedTaskQueueToolHolder<T extends Serializable>
implements Closeable {
    private final Map<String, LatestOnlyDelayedTaskQueueTool<T>> latestOnlyDelayedTaskQueueToolMap = new ConcurrentHashMap<String, LatestOnlyDelayedTaskQueueTool<T>>();
    private final RedissonClient redissonClient;

    public LatestOnlyDelayedTaskQueueToolHolder(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public LatestOnlyDelayedTaskQueueTool<T> register(String taskName, Class<T> clazz, DelayedTaskExecutor<T> executor, Function<T, Long> latestExecuteTimeProvider) {
        return this.latestOnlyDelayedTaskQueueToolMap.computeIfAbsent(taskName, k -> {
            LatestOnlyDelayedTaskQueueTool queueTool = new LatestOnlyDelayedTaskQueueTool(this.redissonClient, taskName, clazz, executor, latestExecuteTimeProvider);
            queueTool.init();
            return queueTool;
        });
    }

    public LatestOnlyDelayedTaskQueueTool<T> get(String taskName) {
        return this.latestOnlyDelayedTaskQueueToolMap.get(taskName);
    }

    @Override
    public void close() throws IOException {
        this.latestOnlyDelayedTaskQueueToolMap.values().forEach(LifeCycle::destroy);
    }
}

