package com.bxm.warcar.ip.impl;

import com.alibaba.sec.client.FastIPGeoClient;
import com.alibaba.sec.domain.FastGeoConf;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;

/**
 * @author allen
 * @date 2021-04-20
 * @since 1.0
 */
public class AliyunIpLibrary extends LifeCycle implements IpLibrary {

    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunIpLibrary.class);
    private final String filePath;
    private final String licenseFilePath;

    private FastIPGeoClient fastIPGeoClient;

    public AliyunIpLibrary(String filePath, String licenseFilePath) {
        this.filePath = filePath;
        this.licenseFilePath = licenseFilePath;
    }

    @Override
    protected void doInit() {
        this.refresh();
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public IP find(String ip) {
        try {
            String search = this.fastIPGeoClient.search(ip);
            if (StringUtils.isNotBlank(search)) {
                Result result = JsonHelper.convert(search, Result.class);
                IP i = new IP();
                i.setCountry(result.getCountry());
                i.setCountrycode(result.getCountry_code());
                i.setProvince(result.getProvince());
                i.setCity(result.getCity());
                i.setCounty(result.getCounty());
                i.setIsp(result.getIsp());
                i.setLongitude(result.getLongitude());
                i.setLatitude(result.getLatitude());
                String regionCode = StringUtils.isNotBlank(result.getCity_code()) ? result.getCity_code()
                        : StringUtils.isNotBlank(result.getProvince_code()) ? result.getProvince_code()
                        : result.getCountry_code();
                i.setRegioncode(regionCode);
                i.setCountycode(result.getCounty_code());
                return i;
            }
        } catch (Exception e) {
            LOGGER.warn("findIp: {}", ip);
        }
        return null;
    }

    @Override
    public synchronized void refresh() {
        try {
            long start = System.currentTimeMillis();
            FastGeoConf geoConf = new FastGeoConf();
            geoConf.setDataFilePath(filePath);
            geoConf.setLicenseFilePath(licenseFilePath);

            HashSet<String> set = new HashSet<>(Arrays.asList(
                    "country", "country_code", "province", "province_code",
                    "city", "city_code", "county", "county_code",
                    "isp", "isp_code", "routes",
                    "longitude", "latitude"
            ));
            geoConf.setProperties(set);
            geoConf.filterEmptyValue();
            this.fastIPGeoClient = FastIPGeoClient.getSingleton(geoConf);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ip library (aliyun) load finished in {} ms", (System.currentTimeMillis() - start));
            }
        } catch (Exception e) {
            throw new RuntimeException("refresh: ", e);
        }
    }

    private static class Result implements Serializable {

        private static final long serialVersionUID = -4731354983202603658L;
        private String country;
        private String country_code;
        private String province;
        private String province_code;
        private String city;
        private String city_code;
        private String county;
        private String county_code;
        private String isp;
        private String isp_code;
        private String routes;
        private String longitude;
        private String latitude;

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getCountry_code() {
            return country_code;
        }

        public void setCountry_code(String country_code) {
            this.country_code = country_code;
        }

        public String getProvince() {
            return province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getProvince_code() {
            return province_code;
        }

        public void setProvince_code(String province_code) {
            this.province_code = province_code;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getCity_code() {
            return city_code;
        }

        public void setCity_code(String city_code) {
            this.city_code = city_code;
        }

        public String getCounty() {
            return county;
        }

        public void setCounty(String county) {
            this.county = county;
        }

        public String getCounty_code() {
            return county_code;
        }

        public void setCounty_code(String county_code) {
            this.county_code = county_code;
        }

        public String getIsp() {
            return isp;
        }

        public void setIsp(String isp) {
            this.isp = isp;
        }

        public String getIsp_code() {
            return isp_code;
        }

        public void setIsp_code(String isp_code) {
            this.isp_code = isp_code;
        }

        public String getRoutes() {
            return routes;
        }

        public void setRoutes(String routes) {
            this.routes = routes;
        }

        public String getLongitude() {
            return longitude;
        }

        public void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        public String getLatitude() {
            return latitude;
        }

        public void setLatitude(String latitude) {
            this.latitude = latitude;
        }
    }
}
