package com.bxm.warcar.ip.impl;

import com.bxm.warcar.ip.*;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * ip库集的匹配库，目前仅支持多个ip库识别后的城市名称进行匹配，如果库集全部匹配，那么则返回第一个库的结果。否则匹配失败返回<code>null</code>
 *
 * @author allen
 * @since 1.0.0
 */
public class SetMatchedIpLibrary implements MatchedIpLibrary {

    private final List<IpLibrary> libraries;

    public SetMatchedIpLibrary(List<IpLibrary> libraries) {
        this.libraries = libraries;
    }

    @Override
    public IpResultSet find(String ip) {
        if (CollectionUtils.isEmpty(libraries)) {
            return null;
        }
        IpResultSet resultSet = new IpResultSet();
        for (IpLibrary library : libraries) {
            IP rs = library.find(ip);
            resultSet.add(new IpResult(library.getClass().getName(), rs));
        }
        return resultSet;
    }
}
