/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpResult;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class IpResultSet
implements Serializable {
    private static final long serialVersionUID = -5478457743871613741L;
    private List<IpResult> results = Lists.newArrayList();

    public void add(IpResult ipResult) {
        this.results.add(ipResult);
    }

    public IP get() {
        if (CollectionUtils.isEmpty(this.results)) {
            return null;
        }
        for (IpResult result : this.results) {
            IP ip = result.getIp();
            if (null == ip) continue;
            return ip;
        }
        return null;
    }

    public boolean isMatched() {
        if (CollectionUtils.isEmpty(this.results)) {
            return true;
        }
        int size = this.results.size();
        if (size == 1) {
            return true;
        }
        String first = null;
        for (int i = 0; i < size; ++i) {
            IP ip = this.results.get(i).getIp();
            if (null == ip) continue;
            if (i == 0) {
                first = ip.getHitcode();
                continue;
            }
            if (StringUtils.equals((String)first, (String)ip.getHitcode())) continue;
            return false;
        }
        return true;
    }

    public List<IpResult> getResults() {
        return this.results;
    }

    public void setResults(List<IpResult> results) {
        this.results = results;
    }
}

