/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging.extension;

import com.aliyun.openservices.aliyun.log.producer.Callback;
import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.aliyun.openservices.log.common.LogItem;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AliyunLogServiceCustomLoggingWriter
implements CustomLoggingWriter,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AliyunLogServiceCustomLoggingWriter.class);
    private final ProducerConfig producerConfig;
    private final ProjectConfig projectConfig;
    private final String logStore;
    private ThreadPoolExecutor executor;
    private LogProducer producer;

    public AliyunLogServiceCustomLoggingWriter(ProducerConfig producerConfig, ProjectConfig projectConfig, String logStore) {
        this.producerConfig = producerConfig;
        this.projectConfig = projectConfig;
        this.logStore = logStore;
    }

    @Override
    public void write(final Map<String, String> data) {
        if (Objects.nonNull(this.executor)) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    AliyunLogServiceCustomLoggingWriter.this.send(data);
                }
            });
        } else {
            this.send(data);
        }
    }

    private void send(Map<String, String> data) {
        if (MapUtils.isEmpty(data)) {
            return;
        }
        LogItem logItem = new LogItem();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            logItem.PushBack(entry.getKey(), entry.getValue());
        }
        try {
            this.producer.send(this.projectConfig.getProject(), this.logStore, logItem, new Callback(){

                public void onCompletion(Result result) {
                    if (!result.isSuccessful()) {
                        log.warn("{}", (Object)result.getErrorMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("send: ", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        try {
            this.producer.close();
        }
        catch (ProducerException | InterruptedException e) {
            log.error("close: ", e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.producer = new LogProducer(this.producerConfig);
        this.producer.putProjectConfig(this.projectConfig);
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }
}

