/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging.support;

import com.bxm.warcar.logging.Logging;
import com.bxm.warcar.logging.LoggingWriter;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongodbLoggingWriter
implements LoggingWriter,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongodbLoggingWriter.class);
    private final MongoTemplate mongoTemplate;
    private final LinkedBlockingQueue<Logging> queue;
    private final ScheduledExecutorService consumer;

    public MongodbLoggingWriter(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        this.queue = new LinkedBlockingQueue();
        this.consumer = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("queue-consumer"));
        this.startConsumer();
    }

    public void destroy() throws Exception {
        this.consumer.shutdown();
        this.consumer.awaitTermination(5L, TimeUnit.SECONDS);
    }

    private void startConsumer() {
        this.consumer.scheduleWithFixedDelay(() -> {
            try {
                ArrayList dest = new ArrayList(100);
                this.queue.drainTo(dest, 100);
                this.mongoTemplate.insert(dest, Logging.class);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }, 10L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void write(Logging logging) {
        while (!this.queue.offer(logging)) {
            try {
                this.queue.take();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

