package com.bxm.warcar.logging.support;

import com.bxm.warcar.logging.Logging;
import com.bxm.warcar.logging.LoggingWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author allen
 * @since 2020-03-18
 */
public class LoggerLoggingWriter implements LoggingWriter {

    private final static Logger LOGGER = LoggerFactory.getLogger(LoggerLoggingWriter.class);

    @Override
    public void write(Logging logging) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(logging.toString());
        }
    }
}
